Public Class Main

  Private Overloads Shared Function ValidCommandLine(ByVal CommandLine As String) As Boolean
    Return Sorter.Valid(CommandLine)
  End Function

  Public Shared Sub Process(ByVal CommandLine As String)
    If (ValidCommandLine(CommandLine) And Not Help.WantsHelp(CommandLine)) Then
      Sorter.Sort(CommandLine)
    Else
      Help.Show()
    End If

  End Sub

  Public Overloads Shared Sub Main()
    Process(Command())
  End Sub

End Class


Public Class Sorter
  Private FFileName As String
  Private FData As ArrayList

  Public Property Data() As ArrayList
    Get
      Return FData
    End Get
    Set(ByVal Value As ArrayList)
      If (FData.Equals(Value)) Then Exit Property
      FData.Clear()
      FData = Value.GetRange(0, Value.Count)
    End Set
  End Property

  Public Property FileName() As String
    Get
      Return FFileName
    End Get
    Set(ByVal Value As String)
      FFileName = Value
    End Set
  End Property

  Public Sub New(ByVal AFileName As String)
    FData = New ArrayList()
    FFileName = AFileName
  End Sub

  Public Sub Read()
    Dim Reader As IO.TextReader = IO.File.OpenText(FFileName)

    Try
      While Reader.Peek <> -1
        FData.Add(Reader.ReadLine)
      End While

    Finally
      Reader.Close()
    End Try

  End Sub

  Public Sub TimedSort()
    Dim Start As Double = Timer
    Sort()
    Debug.WriteLine("Elapsed milliseconds: " & Timer - Start)
  End Sub

  Public Sub Sort()
    FData.Sort(New StringComparer())
  End Sub

  Public Sub Write()
    Dim Writer As IO.TextWriter = IO.File.CreateText("..\Herrick.txt")
    Dim Enumerator As IEnumerator = FData.GetEnumerator

    Try
      While Enumerator.MoveNext
        Writer.WriteLine(Enumerator.Current)
      End While

    Finally
      Writer.Close()
    End Try

  End Sub

  Private Sub Run()
    Read()
    TimedSort()
    Write()
  End Sub

  Public Shared Sub Sort(ByVal FileName As String)
    Dim Instance As New Sorter(FileName)
    Dim Thread As New Threading.Thread(AddressOf Instance.Run)
    Thread.Start()
  End Sub

  Public Shared Function Valid(ByVal CommandLine As String) As Boolean
    Return System.IO.File.Exists(CommandLine)
  End Function

End Class

Public Class Help
  Private Shared Function ContainsHelpSwitch(ByVal CommandLine As String) As Boolean

    Return CommandLine.IndexOf("-?") > -1 Or _
      CommandLine.ToUpper.IndexOf("-H") > -1 Or _
      CommandLine.ToUpper.IndexOf("-HELP") > -1 Or CommandLine = ""

  End Function

  Public Shared Function WantsHelp(ByVal CommandLine As String) As Boolean
    Return ContainsHelpSwitch(CommandLine)
  End Function

  Public Shared Function Usage() As String
    Return _
      "Usage: filesort filename.txt | [-h,-?-help] " & vbCrLf & _
      "Sorts lines of text in file" & vbCrLf & _
      "-h|-?-help - Displays the help message" & vbCrLf
  End Function

  Public Shared Sub Show()
    Console.WriteLine(Usage())
  End Sub
End Class

Public Class StringComparer
  Implements IComparer

  Public Function Compare(ByVal x As Object, ByVal y As Object) As Integer Implements System.Collections.IComparer.Compare
    Return String.Compare(x.ToString.Substring(0, 3), y.ToString.Substring(0, 3))
  End Function
End Class